using MappingFwkDemo.Toolbox.Family.Model;

namespace MappingFwkDemo.Toolbox.Family
{
    public class FamilyStreamImporterExcel : FamilyRepository.StreamImporter
    {
        private readonly Dictionary<string, Person> _personLookup;

        public FamilyStreamImporterExcel(Stream input) : base(input)
        {
            _personLookup = new Dictionary<string, Person>();
        }

        public override IEnumerable<IFamilyObject> Import()
        {
            var result = new List<IFamilyObject>();
            var reader = new ExcelReader();
            reader.ReadExcelFile(Stream);

            return result;
        }

        private Person GetPerson(Type type, string uid, string firstName = null, string lastName = null)
        {
            Person instance = null;
            if (string.IsNullOrEmpty(uid) == false)
            {
                if (_personLookup.TryGetValue(uid, out instance) == false)
                {
                    instance = Activator.CreateInstance(type) as Person;
                    instance.Uid = uid;
                    _personLookup[uid] = instance;
                }
                if (firstName != null)
                {
                    instance.FirstName = firstName;
                }
                if (lastName != null)
                {
                    instance.LastName = lastName;
                }
            }
            return instance;
        }
    }
}
