﻿using MappingFwkDemo.Toolbox.Family.Model;

namespace MappingFwkDemo.Toolbox.Family
{
    public class FamilyStreamImporter : FamilyRepository.StreamImporter
    {
        private readonly Dictionary<string, Person> _personLookup;

        public FamilyStreamImporter(Stream input) : base(input)
        {
            _personLookup = new Dictionary<string, Person>();
        }

        public override IEnumerable<IFamilyObject> Import()
        {
            var result = new List<IFamilyObject>();
            using (var file = new StreamReader(Stream))
            {
                while (file.EndOfStream == false)
                {
                    string line = file.ReadLine();
                    string[] parts = line.Split(';');
                    string uid = parts[0];
                    string typeName = $"MappingFwkDemo.Toolbox.Family.Model.{parts[1]}";
                    Type type = Type.GetType(typeName, true, true);
                    string firstName = parts.ElementAtOrDefault(2);
                    string lastName = parts.ElementAtOrDefault(3);
                    Person instance = GetPerson(type, uid, firstName, lastName);
                    instance.Father = (Male)GetPerson(typeof(Male), parts.ElementAtOrDefault(4));
                    instance.Mother = (Female)GetPerson(typeof(Female), parts.ElementAtOrDefault(5));
                    result.Add(instance);
                    if (instance.Father == null)
                    {
                        ReportWarning($"The {type.Name} '{firstName} {lastName}' #{uid} is missing a father");
                        AddSummaryWarning("Missing parent");
                    }
                    if (instance.Mother == null)
                    {
                        ReportWarning($"The {type.Name} '{firstName} {lastName}' #{uid} is missing a mother");
                        AddSummaryWarning("Missing parent");
                    }
                }
            }

            return result;
        }

        private Person GetPerson(Type type, string uid, string firstName = null, string lastName = null)
        {
            Person instance = null;
            if (string.IsNullOrEmpty(uid) == false)
            {
                if (_personLookup.TryGetValue(uid, out instance) == false)
                {
                    instance = Activator.CreateInstance(type) as Person;
                    instance.Uid = uid;
                    _personLookup[uid] = instance;
                }
                if (firstName != null)
                {
                    instance.FirstName = firstName;
                }
                if (lastName != null)
                {
                    instance.LastName = lastName;
                }
            }
            return instance;
        }
    }
}
