﻿using MappingFwkDemo.Toolbox.Family.Model;
using System.Text;

namespace MappingFwkDemo.Toolbox.Family
{
    public class FamilyStreamExporter : FamilyRepository.StreamExporter
    {
        public FamilyStreamExporter(Stream output) : base(output)
        {
        }

        public override void Export(IEnumerable<IFamilyObject> objects)
        {
            using (var file = new StreamWriter(Stream, Encoding.UTF8, 8192, true))
            {
                foreach (var item in objects)
                {
                    string uid = item.Uid;
                    Type type = item.GetType();
                    Person p = (Person)item;
                    file.WriteLine($"{uid};{type.Name};{p.FirstName ?? string.Empty};{p.LastName ?? string.Empty};{p.Father?.Uid ?? string.Empty};{p.Mother?.Uid ?? string.Empty}");
                }
                file.Flush();
            }
        }
    }
}
