using Eurostep.ModelFramework.Toolbox;

namespace MappingFwkDemo.Toolbox.Family
{
    public partial class FamilyRepository : Repository<string, IFamilyObject>
    {
        private uint s_keyCounter = 1;

        public override void Export(Stream output, string type)
        {
            Export(new FamilyStreamExporter(output));
        }

        public override void Import(Stream input, string type)
        {
            switch (type)
            {
                case "csv":
                    Import(new FamilyStreamImporter(input));
                    break;
                case "xlsx":
                    Import(new FamilyStreamImporterExcel(input));
                    break;
                default:
                    break;
            }
        }

        protected override string GetKey(IFamilyObject entity)
        {
            return entity.Uid;
        }

        protected override string NextKey()
        {
            return $"{s_keyCounter++}";
        }

        protected override void SetKey(string key, IFamilyObject entity)
        {
            entity.Uid = key;
        }

        public void Write(string fileName)
        {
            if (File.Exists(fileName) == true)
            {
                File.Delete(fileName);
            }
            using (var file = new FileStream(fileName, FileMode.CreateNew))
            {
                Export(file, Path.GetExtension(fileName));
            }
        }

        public void Read(string fileName)
        {
            using (var file = new FileStream(fileName, FileMode.Open))
            {
                Import(file, Path.GetExtension(fileName));
            }
        }
    }
}
