﻿namespace MappingFwkDemo.Toolbox.Family
{
    public abstract class FamilyObject : IFamilyObject
    {
        public string Uid { get; set; }

        public override bool Equals(object obj)
        {
            FamilyObject o = obj as FamilyObject;
            if (!string.IsNullOrWhiteSpace(Uid) && o != null && obj.GetType() == GetType())
            {
                return string.Equals(Uid, o.Uid, System.StringComparison.Ordinal);
            }
            return false;
        }

        public override int GetHashCode()
        {
            if (!string.IsNullOrWhiteSpace(Uid))
            {
                return Uid.GetHashCode();
            }

            return base.GetHashCode();
        }

        public override string ToString()
        {
            var thisType = GetType();
            return string.Format("{0} #{1}", thisType.Name, Uid ?? string.Empty);
        }
    }
}
