﻿using DocumentFormat.OpenXml.Packaging;
using DocumentFormat.OpenXml.Spreadsheet;

namespace MappingFwkDemo.Toolbox.Family;

public class ExcelReader
{
    public void ReadExcelFile(string filePath)
    {
        using (SpreadsheetDocument doc = SpreadsheetDocument.Open(filePath, false))
        {
            ReadSpreadsheet(doc);
        }
    }

    public void ReadExcelFile(Stream stream)
    {
        using (SpreadsheetDocument doc = SpreadsheetDocument.Open(stream, false))
        {
            ReadSpreadsheet(doc);
        }
    }
    private void ReadSpreadsheet(SpreadsheetDocument doc)
    {
        WorkbookPart workbookPart = doc.WorkbookPart;
        Sheet sheet = workbookPart.Workbook.Descendants<Sheet>().First();
        WorksheetPart worksheetPart = (WorksheetPart)workbookPart.GetPartById(sheet.Id);
        Worksheet worksheet = worksheetPart.Worksheet;

        SharedStringTablePart stringTablePart = workbookPart.SharedStringTablePart;
        List<Row> rows = worksheet.Descendants<Row>().ToList();

        foreach (Row row in rows)
        {
            foreach (Cell cell in row)
            {
                string cellValue = GetCellValue(cell, stringTablePart);
                Console.Write(cellValue + "\t");
            }
            Console.WriteLine();
        }
    }

    private string GetCellValue(Cell cell, SharedStringTablePart stringTablePart)
    {
        if (cell.DataType != null && cell.DataType.Value == CellValues.SharedString)
        {
            return stringTablePart.SharedStringTable.ChildElements[int.Parse(cell.CellValue.Text)].InnerText;
        }
        else
        {
            return cell.CellValue.Text;
        }
    }
}