using Eurostep.ModelFramework.Mapping;
using MappingFwkDemo.Toolbox.Family.Model;

namespace MappingFwkDemo.Mapper.FamilyToD2M.Mappings
{
    [PublicMapping]
    public class MaleToPersonDefaultInMapping : FamilyToD2MMapping<Male, Eurostep.D2M.Domain.Model.Model.PersonNamespace.Input.defaultIn>
    {
        protected override async Task Map()
        {
            Male familyMale = SourceObject;
            Eurostep.D2M.Domain.Model.Model.PersonNamespace.Input.defaultIn person = CreateTarget();
            person.id = $"Male {familyMale.FirstName} {familyMale.LastName}";
            person.firstName = familyMale.FirstName;
            person.lastName = familyMale.LastName;

            // for show
            if (familyMale.Father != null)
            {
                var father = await this.Require<MaleToPersonDefaultInMapping>().Map(familyMale.Father);
            }

            if (familyMale.Mother != null)
            {
                var mother = await this.Require<FemaleToPersonDefaultInMapping>().Map(familyMale.Mother);
            }
        }
    }
}
