using Eurostep.ModelFramework.Mapping;
using MappingFwkDemo.Toolbox.Family.Model;

namespace MappingFwkDemo.Mapper.FamilyToD2M.Mappings
{
    [PublicMapping]
    public class FemaleToPersonDefaultInMapping : FamilyToD2MMapping<Female, Eurostep.D2M.Domain.Model.Model.PersonNamespace.Input.defaultIn>
    {
        public FemaleToPersonDefaultInMapping()
        {
            IdentifiedBy = (left, right) =>
            {
                return left.FirstName == right.FirstName;
            };
        }

        protected override async Task Map()
        {
            Female familyFemale = SourceObject;
            Eurostep.D2M.Domain.Model.Model.PersonNamespace.Input.defaultIn person = CreateTarget();
            person.id = $"Female {familyFemale.FirstName} {familyFemale.LastName}";
            person.firstName = familyFemale.FirstName;
            person.lastName = familyFemale.LastName;


            if (familyFemale.Father != null)
            {
                var father = await this.Require<MaleToPersonDefaultInMapping>().Map(familyFemale.Father);
            }

            if (familyFemale.Mother != null)
            {
                var mother = await this.Require<FemaleToPersonDefaultInMapping>().Map(familyFemale.Mother);
            }
        }
    }
}
