namespace Eurostep.D2M.Domain.Model
{
    using Eurostep.ModelFramework.Toolbox;
    using System.IO;
    using System;

    /// <summary>
    /// SoftTypeRepository for Nova
    /// </summary>
    public class SoftTypeRepository : Repository<string, SoftTypeBaseObject>
    {
        private int idCounter = 1;

        /// <summary>
        /// 
        /// </summary>
        public bool UpdateInverses { get; set; }

        /// <summary>
        /// 
        /// </summary>
        public SoftTypeRepository()
            : base()
        {
            this.UpdateInverses = false;
        }


        /// <summary>
        /// 
        /// </summary>
        /// <param name="file"></param>
        public void WriteJson(Stream file, bool validateSchema)
        {
            var writer = SoftTypeJsonFileExporter.Create(file, validateSchema);
            this.Export(writer);
        }

        /// <summary>
        ///
        /// </summary>
        /// <param name="file"></param>
        public void WriteJson(Stream file)
        {
            this.WriteJson(file, true);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="file"></param>
        /// <param name="validateSchema"></param>
        public void ReadJson(Stream file, bool validateSchema)
        {
            var reader = SoftTypeJsonFileImporter.Create(file, validateSchema);
            this.Import(reader);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="file"></param>
        public void ReadJson(Stream file)
        {
            this.ReadJson(file, true);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="entity"></param>
        /// <returns></returns>
        protected override string GetKey(SoftTypeBaseObject entity)
        {
            return entity.Uid;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="key"></param>
        /// <param name="entity"></param>
        protected override void SetKey(string key, SoftTypeBaseObject entity)
        {
            entity.Uid = key;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        protected override string NextKey()
        {
            return string.Format("i{0}", idCounter++);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="o"></param>
        protected override void RegisterEntityForChangeEvent(SoftTypeBaseObject o)
        {
            if (this.UpdateInverses)
            {
                ((SoftTypeBaseObject)o).OnModified = this.Update;
            }
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="input"></param>
        /// <param name="type"></param>
        public override void Import(Stream input, string type)
        {
            this.ReadJson(input);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="output"></param>
        /// <param name="type"></param>
        public override void Export(Stream output, string type)
        {
            this.WriteJson(output);
        }
    }
}