using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Eurostep.D2M.Domain.Model
{
    [AttributeUsage(AttributeTargets.Property, Inherited = false)]
    public class SoftTypePropertyAttribute : Attribute
    {
        public SoftTypePropertyAttribute()
        {
        }

        public bool CheckContainmentRule(int count)
        {
            string countStr = count.ToString();

            if (countStr.CompareTo(LowerRule) < 0)
                return false;

            if (UpperRule == "*")
                return true;

            if (countStr.CompareTo(UpperRule) > 0)
                return false;

            return true;
        }

        public static string MakeSoftTypePropertyAttributeString(bool required, Tuple<string, string> rule, string errorMessage)
        {
            if (rule == null)
            {
                if(required)
                {
                    rule = new Tuple<string, string>("1", "1");
                }
                else
                {
                    rule = new Tuple<string, string>("0", "1");
                }
            }

            string requiredStr = required ? "true" : "false";
            return $"[SoftTypeProperty(Required={requiredStr}, LowerRule=\"{rule.Item1}\", UpperRule=\"{rule.Item2}\", ErrorMessage=\"{errorMessage}\")]";
        }

        public bool Required { get; set; }
        public string LowerRule { get; set; }
        public string UpperRule { get; set; }
        public string ErrorMessage { get; set; }
    }
}
