namespace Eurostep.D2M.Domain.Model
{
    using Eurostep.ModelFramework.Toolbox;
    using Newtonsoft.Json;
    using Newtonsoft.Json.Linq;
    using System.Collections.Generic;
    using System.IO;

    public class SoftTypeJsonFileImporter : SoftTypeRepository.StreamImporter
    {
        public bool ValidateSchema { get; set; }

        public SoftTypeJsonFileImporter(Stream input, bool validateSchema = true)
        : base(input)
        {
            this.ValidateSchema = validateSchema;
        }

        /// <summary>
        /// Creates a <see cref="SoftTypeJsonFileImporter"/> instance that can be used
        /// to read SoftType Json file into a <see cref="SoftTypeRepository"/>.
        /// </summary>
        /// <param name="file">The file on disk</param>
        /// <returns>A <see cref="Reader"/> instance that can be used with a <see cref="Repository"/></returns>
        public static SoftTypeJsonFileImporter Create(Stream input, bool validateSchema)
        {
            return new SoftTypeJsonFileImporter(input, validateSchema);
        }

        public override IEnumerable<SoftTypeBaseObject> Import()
        {
            var deserializer = new SoftTypeDeserializer();
            var instances = deserializer.deserialize(this.Stream);
            if (ValidateSchema) SoftTypeValidator.Validation(instances);
            return instances;
        }
    }
}
