namespace Eurostep.D2M.Domain.Model
{
    using System;
    using System.Collections;
    using System.Collections.Generic;
    using System.IO;
    using System.Linq;
    using System.Xml;
    using System.Xml.Serialization;

    public class SoftTypeJsonFileExporter : SoftTypeRepository.StreamExporter
    {
        public bool ValidateSchema { get; set; }

        public SoftTypeJsonFileExporter(Stream file, bool validateSchema = true)
            : base(file)
        {
            this.ValidateSchema = validateSchema;
        }

        /// <summary>
        /// Creates a <see cref="SoftTypeJsonFileExporter"/> that can be used to write all
        /// content of a <see cref="SoftTypeRepository"/> to the <paramref name="file"/>.
        /// </summary>
        /// <param name="file">The file that the content will be written to</param>
        /// <returns>A new <see cref="Writer"/> instance.</returns>
        public static SoftTypeJsonFileExporter Create(Stream file, bool validateSchema)
        {
            return new SoftTypeJsonFileExporter(file, validateSchema);
        }

        /// <summary>
        /// Creates a <see cref="SoftTypeJsonFileExporter"/> that can be used to write all
        /// content of a <see cref="SoftTypeRepository"/> to the <paramref name="path"/>.
        /// </summary>
        /// <param name="path">The file path that the content will be written to</param>
        /// <returns>A new <see cref="Writer"/> instance.</returns>
        public override void Export(IEnumerable<SoftTypeBaseObject> objects)
        {
            if (ValidateSchema) SoftTypeValidator.Validation(objects);
            var dataSection = objects.ToArray();
            var serializer = new SoftTypeSerializer();
            serializer.Serialize(dataSection, this.Stream);
        }
    }
}
