
using System;
using System.Collections.Generic;

namespace Eurostep.D2M.Domain.Model
{
    public class SoftTypeBaseObject : ISoftTypeBaseObject
    {
        public string Uid { get; set; }

        public bool IsConnection { get; set; }

        public virtual string SoftTypeName { get; }

        internal Action<SoftTypeBaseObject> OnModified;

        static private int InstanceCount = 0;

        protected SoftTypeBaseObject(string uid = null)
        {
            InstanceCount++;

            if (!string.IsNullOrWhiteSpace(uid))
                this.Uid = uid;
            else
                this.Uid = InstanceCount.ToString();
        }

        public override bool Equals(object obj)
        {
            if (obj == null)
            {
                return false;
            }

            if (obj.GetType() != this.GetType())
            {
                return false;
            }

            var o = obj as SoftTypeBaseObject;
            return string.Equals(this.Uid, o?.Uid, System.StringComparison.Ordinal);
        }

        public override int GetHashCode()
        {
            if (!string.IsNullOrWhiteSpace(this.Uid))
            {
                return this.Uid.GetHashCode();
            }

            return base.GetHashCode();
        }

        public override string ToString()
        {
            var thisType = this.GetType();
            return string.Format("{0} #{1}", thisType.Name, this.Uid ?? string.Empty);
        }

        protected void Modify()
        {
            this.OnModified?.Invoke(this);
        }
    }
}
