using System;

namespace Eurostep.D2M.Domain.Model.Model
{
    public enum AccessRights : int
    {
        None = 0,
        Create = 1,
        Read = 2,
        Update = 4,
        Delete = 8,
        FileVaultAccess = 16,
        ExecuteOperation = 32,
        Awareness = 64,
        GrantDetailedAccess = 128,
        GrantUserAccess = 256,
        GrantParticipantAccess = 512,
        GrantExternalAccess = 1024,
        ManageSpaceDefinition = 2048,
    }

    public enum DaysOfWeek : byte
    {
        None = 0,
        Monday = 1,
        Tuesday = 2,
        Wednesday = 4,
        Thursday = 8,
        Friday = 16,
        Saturday = 32,
        Sunday = 64,
    }

    public enum DetailedAccessRights : byte
    {
        None = 0,
        Read = 2,
        Update = 4,
        Delete = 8,
        FileVaultAccess = 16,
        ExecuteOperation = 32,
    }

    public enum DxQueueStatus : byte
    {
        Running,
        Stopped,
    }

    public enum DxStage : byte
    {
        NoStaging,
        MandatoryStaging,
        AdaptiveStaging,
    }

    public enum DxStatus : byte
    {
        None,
        Queued,
        Running,
        Completed,
        Failed,
        Canceled,
        StagedError,
        StagedWarn,
        StagedOk,
        Comitting,
    }

    public enum ExternalAccessRights : byte
    {
        None = 0,
        Read = 2,
        Update = 4,
        Delete = 8,
        FileVaultAccess = 16,
        ExecuteOperation = 32,
        Awareness = 64,
    }

    public enum LevelStateEnum : byte
    {
        InWork,
        SemiFrozen,
        Frozen,
    }

    public enum MessageThreadState : byte
    {
        Open,
        Closed,
    }

    public enum ModuleType : byte
    {
        Ordinary,
        IdDependent,
    }

    public enum OAuthFlow : byte
    {
        Implicit,
        Code,
        ResourceOwner,
        Client,
        Assertion,
    }

    public enum RecursiveShareLevel : byte
    {
        Implicit,
        Read,
        Edit,
    }

    public enum ShareLevel : byte
    {
        None,
        Read,
        Edit,
    }

    public enum SpaceStatus : byte
    {
        Initialization,
        Started,
    }

    public enum TokenType : byte
    {
        SAML20,
        JWT,
    }

    public enum WorkItemState : byte
    {
        Open,
        Closed,
        Rejected,
    }

    public interface IConnection
    {
        string oid { get; set; }
    }

    public class ObjectId
    {
        [SoftTypeProperty(Required = true, LowerRule = "1", UpperRule = "1", ErrorMessage = "Property oid of ObjectId is required.")]
        public string oid {get; set;}
    }
}
