namespace Eurostep.D2M.Domain.Model
{
	using System.Collections.Generic;
	public static class NormalizedIdentifierLookupTable
	{
		private static Dictionary<string, string> _originToNormalizedlookup = SetUpOriginToNormalizedlookupTable();

		private static Dictionary<string, string> _normalizedToOriginlookup = SetUpNormalizedToOriginlookupTable();
		private static Dictionary<string, string> SetUpOriginToNormalizedlookupTable()
		{
			return new Dictionary<string, string>()
			{
			["operator"] = "@operator",
			};
		}

		private static Dictionary<string, string> SetUpNormalizedToOriginlookupTable()
		{
			return new Dictionary<string, string>()
			{
			["@operator"] = "operator",
			};
		}

		public static bool TryGetNormalizedIdentifier(string origin, out string normalized)
		{
			return _originToNormalizedlookup.TryGetValue(origin, out normalized);
		}

		public static bool TryGetOriginIdentifier(string normalized, out string origin)
		{
			return _normalizedToOriginlookup.TryGetValue(normalized, out origin);
		}
	}
}